#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>

#define UNDEFINED -1
#define TOTAL_VEHICLES 15
#define SPAWN_TIME 15

pthread_cond_t nadvoznjakCond;
pthread_mutex_t nadvoznjakMutex;

int kamion = 0; //flag
int trenutniSmer = UNDEFINED;//svaki put kada je counter 0 ,vraca se na undefined.. vrednosti: 0,1,-1
int nextId = 0;
int counter = 0; //broji smer

void * prelazak(void*args){
    sleep((rand()+1)%SPAWN_TIME);//random interval od 0-15 sekundi, kraci primer radi preglednostis

    pthread_mutex_lock(&nadvoznjakMutex);
    int tipVozila = rand()%5;// ako je 0 , onda je kamion

    int id = nextId;
    nextId++;
    int smerdolaska = rand()%2;//random s jedne ili druge strane

    if(tipVozila){
        printf("PRISTUP: Auto %d pristupa prelazu iz smera %d\n",id,smerdolaska);

        while(kamion > 0 || (trenutniSmer != UNDEFINED && (trenutniSmer != smerdolaska && counter!=0))){
            pthread_cond_wait(&nadvoznjakCond,&nadvoznjakMutex);
        }

        trenutniSmer = smerdolaska;
        counter++;
        pthread_mutex_unlock(&nadvoznjakMutex);

        printf("\tPRELAZAK: Auto %d prelazi, trenutno iz smera %d prelazi %d automobila\n",id,trenutniSmer,counter);
        sleep(2);//non-random sleep radi redosleda prelazaka..
        printf("\t\tPRELAZAK USPEH: Auto %d je presao\n",id);
        
        pthread_mutex_lock(&nadvoznjakMutex);

        pthread_cond_broadcast(&nadvoznjakCond);
        counter--;
        if(counter==0) trenutniSmer = UNDEFINED;
        pthread_mutex_unlock(&nadvoznjakMutex);
    }else{
        printf("PRISTUP: Kamion %d pristupa prelazu iz smera %d\n",id,smerdolaska);
        
        while(kamion > 0 || counter != 0 && (trenutniSmer != smerdolaska ||  trenutniSmer!=UNDEFINED)){
            pthread_cond_wait(&nadvoznjakCond,&nadvoznjakMutex);
        }

        trenutniSmer = smerdolaska;
        counter++;
        kamion = 1;
        
        pthread_mutex_unlock(&nadvoznjakMutex);

        printf("\tPRELAZAK: Kamion %d prelazi, trenutno iz smera %d prelazi %d\n",id,trenutniSmer,counter);
        sleep(2);
        printf("\t\tPRELAZAK USPEH: Kamion %d je presao\n",id);
        
        pthread_mutex_lock(&nadvoznjakMutex);

        pthread_cond_broadcast(&nadvoznjakCond);

        counter--;
        kamion = 0;
        if(counter==0) trenutniSmer = UNDEFINED;

        pthread_mutex_unlock(&nadvoznjakMutex);
    }
}

int main(){
    srand(time(NULL));
    
    pthread_t threads[TOTAL_VEHICLES];//adjustable za vece primere
    pthread_mutex_init(&nadvoznjakMutex,NULL);
    pthread_cond_init(&nadvoznjakCond,NULL);

    for(int i=0;i<TOTAL_VEHICLES;i++){
        pthread_create(&threads[i],NULL,prelazak,NULL);
    }

    for(int i=0;i<TOTAL_VEHICLES;i++){
        pthread_join(threads[i],NULL);
    }

    return 0;
}